
#include <map>
#include <string>
#include <list>
#include <set>
#include <iostream>
#include <fcntl.h>
#include "MemoryMarker.h"
#include "i8080disasm.h"

using std::cout;
using std::endl;
using std::hex;

int main (int argc, char * const argv[])
{
	unsigned char binaryDataBuf[65536 + 4];
	int binaryStream;
	unsigned int minAddress;
	unsigned int maxAddress;
	const char *hintsFile = NULL;

	if ((argc < 3) || (argc > 4)) {
		cout << "Usage:\n" <<
			"disasm <input RKS file> <output source file> <hints file>\n";
		return 1;
	}

	binaryStream = open(argv[1], O_RDONLY);

	if (binaryStream < 0) {
		cout << "Could not open " << argv[1] << endl;
		return 1;
	}

	if (read(binaryStream, &binaryDataBuf, 65536 + 4) < 1) {
		cout << "Cannot read from " << argv[1] << endl;
		close(binaryStream);
		return -1;
	}

	close(binaryStream);

	minAddress = (unsigned int) binaryDataBuf[0] + ((unsigned int) binaryDataBuf[1] << 8);
	maxAddress = (unsigned int) binaryDataBuf[2] + ((unsigned int) binaryDataBuf[3] << 8);

	if (maxAddress <= minAddress) {
		cout << "The RKS file " << argv[1] << " looks corrupted" << endl;
		close(binaryStream);
		return -1;
	}

	if (argc == 4)
		hintsFile = argv[3];

	i8080disasm disassembler(binaryDataBuf + 4, minAddress, maxAddress, hintsFile);
	disassembler.trace(minAddress);
	disassembler.disassemble(argv[2]);
	return 0;
}
