
// Possible types of instructions //
#define LINEAR 0
#define FORK   1
#define JUMP   2
#define CALL   3
#define RET    4

unsigned int getCommandLength(const unsigned char *command);

// list of available instruction types look definitions above //
unsigned int getInstructionType(const unsigned char *command);

// calculate address of branch for given instruction //
unsigned int getBranchAddress(const unsigned char *command, unsigned int currentAddress);

// Produce source text for given instrucion;                //
// Arguments:                                               //
// code - pointer to the instruction;                       //
// address - address of the instruction;                    //
// text - buffer for source text;                           //
// inlineComment - container for comments, that may be      //
//        produced during reversing;                        //
// labels - collection of known labels and their addresses. // 
void reverseInstruction(const unsigned char *code, unsigned int address, char text[256],
		std::string &inlineComment, std::map<unsigned int, std::string> &labels);
