
class i8080disasm
{
public:
	// code - data to disassemble                     //
	// codeOffset - address of first byte of code     //
	// minAddress and maxAddress - range of addresses //
	//                where disassebbling is required //
	i8080disasm(const unsigned char *code, unsigned int minAddress,
			unsigned int maxAddress, const char *hintsFile);

	// build map of code and data, create labels, etc //
	// start tracing from startAddress                //
	bool trace(unsigned int startAddress);

	bool disassemble(std::string targetFile);

	~i8080disasm();
private:
	const unsigned char* _code;
	unsigned int _codeOffset;
	unsigned int _minAddress;
	unsigned int _maxAddress;

	// first pass marks code labels only //
	// second pass marks data labels     //
	unsigned int passNumber;

	// labels of executable in address:name manner //
	std::map<unsigned int, std::string> labels;
	std::map<unsigned int, std::string> comments;
	std::set<unsigned int> routinesMarks;
	std::list<unsigned int> delayedBranches;
	MemoryMarker traceData;
	unsigned char fetchByte(unsigned int address);
	void labelAddress(unsigned int address);
	bool resumeDelayedBranch(unsigned int *resumedAddress);
	bool findDataLabels();
	bool checkASCII(unsigned int address);
};
