
#include <stdlib.h>
#include <string.h>
#include "MemoryMarker.h"

MemoryMarker::MemoryMarker(unsigned int minAddress, unsigned int maxAddress)
:_minAddress(minAddress), _maxAddress(maxAddress)
{
	_memoryTrace = NULL;
	if (minAddress >= maxAddress)
		return;

	_memoryTrace = (unsigned char *) malloc(_maxAddress - _minAddress + 1);
	memset(_memoryTrace, CELL_UNTRACED, _maxAddress - _minAddress + 1);
}

void MemoryMarker::markCell(unsigned int address, unsigned char traceType)
{
	if ((address < _minAddress) || (address > _maxAddress) || (NULL == _memoryTrace))
		return;

	_memoryTrace[address - _minAddress] = traceType;
}

unsigned char MemoryMarker::getCellTrace(unsigned int address)
{
	if ((address < _minAddress) || (address > _maxAddress) || (NULL == _memoryTrace))
		return CELL_UNTRACED;

	return _memoryTrace[address - _minAddress];
}

MemoryMarker::~MemoryMarker()
{
}

